/*
   Lexical analyser for C++
   ---> generates coloured HTML file
   
   tested with: FLEX and Watcom C++ Version 11.0 and Borland C++ 5.02
		(you have to delete "#include <unistd.h>" manually)

   Copyright (c) 1999 by Michael Neumann (neumann@s-direktnet.de)
   last change: 14.02.1999
*/

%{
   #include <iostream.h>
   #include <fstream.h>
   #include <string.h>
   #include <stdio.h>

   extern "C" int yywrap(){return 1;}

   ofstream coutt;

   void xout(char* c) {	/* output mit substitution von z.B. < > */
	for(int i=0;i<strlen(c);++i) {
		switch(c[i]) {
		case '<':	coutt << "&lt;";break;
		case '>':	coutt << "&gt;";break;
		case '\"':	coutt << "&quot;";break;
		default:	coutt << c[i];
		};
	}
   }
   
   char *end_line;
   #define SZ 256
   char beg_html[SZ], end_html[SZ], beg_ws[SZ], end_ws[SZ], beg_oct[SZ], end_oct[SZ],
	beg_dec[SZ], end_dec[SZ], beg_hex[SZ], end_hex[SZ], beg_float[SZ], end_float[SZ],
	beg_string[SZ], end_string[SZ], beg_char[SZ], end_char[SZ], beg_comment[SZ],
	end_comment[SZ], beg_preproc[SZ], end_preproc[SZ], beg_delim[SZ], end_delim[SZ],
	beg_keyword[SZ], end_keyword[SZ], beg_ident[SZ], end_ident[SZ], beg_curly[SZ], end_curly[SZ];

   int name_len;
%}


ws		[ \n\t\r]
escape		\\(.|\n)


k1              _asm|asm|auto|break|case|_cdecl|cdecl|char|class|const|continue|_cs|default
k2              delete|do|double|_ds|else|enum|_es|_export|extern|_far|far|_fastcall|float
k3              for|friend|goto|_huge|huge|if|inline|int|_interrupt|interrupt|_loadds|long
k4              _near|near|new|operator|_pascal|pascal|private|protected|public|register
k5              return|_saveregs|_seg|short|signed|sizeof|_ss|static|struct|switch|template
k6              this|typedef|union|unsigned|virtual|void|volatile|while
k7		using|namespace|bool|throw|catch|typename|true|false
keyword         {k1}|{k2}|{k3}|{k4}|{k5}|{k6}|{k7}

bezeichner	[a-zA-Z_][a-zA-Z0-9_]*


delim	([!%&/()=?*+~.:<>,;|])|"["|"]"|"-"|"^"

		

unsignedSuffix		u|U
longSuffix		l|L
gleitkommaSuffix	f|F|l|L
hexZiffer		[0-9a-fA-F]
oktalZiffer		[0-7]
ziffer			[0-9]
ziffernFolge		{ziffer}+
nichtnullZiffer		[1-9]
fraktionaleKonstante	(({ziffernFolge}?)"."{ziffernFolge})|({ziffernFolge}".")
vorzeichen		"+"|"-"
exponent		(e|E){vorzeichen}?{ziffernFolge}



oktaleKonstante		0{oktalZiffer}*{integerSuffix}?
hexadezimaleKonstante	(0x|0X){hexZiffer}+{integerSuffix}?
dezimaleKonstante	{nichtnullZiffer}{ziffer}*{integerSuffix}?
integerSuffix		({unsignedSuffix}{longSuffix}?)|({longSuffix}{unsignedSuffix}?)
gleitkommaKonstante	({fraktionaleKonstante}{exponent}?{gleitkommaSuffix}?)|({ziffernFolge}{exponent}{gleitkommaSuffix}?)


%x STR1 STR2 CLINE PLINE COMM NAME
%%

{ws}+                   {coutt << beg_ws; xout(yytext); coutt << end_ws;}



{oktaleKonstante}       {coutt << beg_oct; xout(yytext); coutt << end_oct;}
{dezimaleKonstante}     {coutt << beg_dec; xout(yytext); coutt << end_dec;}
{hexadezimaleKonstante} {coutt << beg_hex; xout(yytext); coutt<< end_hex;}
{gleitkommaKonstante}   {coutt << beg_float; xout(yytext); coutt << end_float;}


\"                      {coutt << beg_string; xout(yytext); BEGIN(STR1);}
\'                      {coutt << beg_char;   xout(yytext); BEGIN(STR2);}
<STR1,STR2>{escape}     {/*escape character*/   xout(yytext);}

<STR1>[^"]              {/*any other than "*/   xout(yytext);}
<STR2>[^']              {/*any other than '*/   xout(yytext);}
<STR1>\"                {/* string end*/ xout(yytext); coutt << end_string;BEGIN(0);}
<STR2>\'                {/* string end*/ xout(yytext); coutt << end_char;BEGIN(0);}

"//"                    {coutt << beg_comment; xout(yytext); BEGIN(CLINE);}
"#"                     {coutt << beg_preproc; xout(yytext); BEGIN(PLINE);}


<CLINE>[^\n\\]*         {xout(yytext);}
<CLINE>(\\)*[^\n]	{xout(yytext);}
<CLINE>\\\n		{xout(yytext);}
<CLINE>\n               {xout(yytext); coutt << end_comment; BEGIN(0);}

<PLINE>\\{ws}*\n        {xout(yytext);}
<PLINE>[^\n]            {xout(yytext);}
<PLINE>\n               {xout(yytext); coutt << end_preproc; BEGIN(0);}




"/*"                    {coutt << beg_comment; xout(yytext); BEGIN(COMM);}

<COMM>[^*]*             {xout(yytext);}
<COMM>"*"*[^/]          {xout(yytext);}
<COMM>"*"*"*/"          {xout(yytext); coutt << end_comment; BEGIN(0);}


"{"			{coutt << beg_curly; xout(yytext); coutt << end_curly;}
"}"			{coutt << beg_curly; xout(yytext); coutt << end_curly;}

{delim}                 {coutt << beg_delim; xout(yytext); coutt << end_delim;}


{bezeichner}		{/* identifier or keyword? */
			name_len = yyleng; yyless(0);BEGIN(NAME);}


<NAME>{keyword}		{
				if(name_len == yyleng) {
                                        coutt << beg_keyword; xout(yytext); coutt << end_keyword;
					BEGIN(0);
				} else REJECT;
			}

<NAME>{bezeichner}      {coutt << beg_ident; xout(yytext); coutt << end_ident; BEGIN(0);}




.                       { coutt << "FEHLER: "; xout(yytext); }



%%

main(int argc,char **argv)
{
	--argc;
	++argv;
	if(argc != 3) printf("USAGE: inputfile colorscheme outputfile\n");
	else
	{		
		yyin = fopen(argv[0],"r");

		
		// Color Scheme einlesen
		FILE* col = fopen(argv[1],"r");		
		char *start = beg_html;
		for(int i=0;i<28;++i) {
			fgets(start,SZ,col);
			start[strlen(start)-1] = '\0';
			start += SZ;
		}
		fclose(col);
				
		coutt.open(argv[2],ios::out);

                coutt << beg_html;
		yylex();
                coutt << end_html;
		fclose(yyin);
	}
}


